<?php
// upload-photo.php
include_once 'koneksi.php'; // pastikan koneksi benar

$data = json_decode(file_get_contents("php://input"));

$presence_id = $data->presence_id ?? null;
$action = $data->action ?? 'in';
$photo = $data->photo ?? '';

if(!$presence_id || !$photo){
    http_response_code(400);
    echo "Data tidak lengkap.";
    exit;
}

// Pastikan folder uploads ada
$upload_dir = __DIR__ . '/uploads/';
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

$filename = 'photo_' . uniqid() . '.jpg';
$filepath = $upload_dir . $filename;
$url_path = 'uploads/' . $filename;

// Simpan file
$photo = str_replace('data:image/jpeg;base64,', '', $photo);
$photo = str_replace(' ', '+', $photo);
$saved = file_put_contents($filepath, base64_decode($photo));

if ($saved === false) {
    http_response_code(500);
    echo "Gagal menyimpan foto.";
    exit;
}

// Update database
$field = $action === 'in' ? 'photo_in' : 'photo_out';
$query = "UPDATE presence SET $field = '$url_path' WHERE presence_id = $presence_id";

if ($connection->query($query)) {
    echo "Foto berhasil disimpan.";
} else {
    http_response_code(500);
    echo "Gagal update database: " . $connection->error;
}
?>
